% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{encode}
\alias{encode}
\alias{decode}
\alias{encode_file}
\alias{decode_file}
\title{Encode and decode using base64}
\usage{
encode(what, eng = engine())

decode(what, eng = engine())

encode_file(path, eng = engine())

decode_file(path, eng = engine())
}
\arguments{
\item{what}{a character, raw, or blob vector}

\item{eng}{a base64 engine. See \code{\link[=engine]{engine()}} for details.}

\item{path}{a path to a base64 encoded file.}
}
\value{
Both \code{encode()} and \code{decode()} are vectorized. They will return a character
and blob vector the same length as \code{what}, respectively.
}
\description{
Encode and decode using base64
}
\examples{
# encode hello world
encoded <- encode("Hello world")
encoded

# decode to a blob
decoded <- decode(encoded)
decoded

# convert back to a character
rawToChar(decoded[[1]])
}
