% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{calibrate_test}
\alias{calibrate_test}
\title{Calibration of pvalues in a slow multi-hypothesis setting}
\usage{
calibrate_test(
  y,
  w = NULL,
  rep = 1e+07,
  doall = TRUE,
  unidirectional = 0,
  flatten = 0.5,
  ignoremax = 0,
  normmethod = 1,
  novariance = F
)
}
\arguments{
\item{y}{A binary vector of sample labels (cases=1, controls=0).}

\item{w}{Default = NULL. Optional numerical vector of weights.
1 means all weights are equal to 1 and only the ordering is considered.
If NULL (default), a standardisation of x is used to calculate the weights
giving larger weights to aberrations of larger magnitude.}

\item{rep}{Default=100000. Number of permutations to be used to calculate p-values.}

\item{doall}{Default=TRUE. All permutations are performed}

\item{unidirectional}{Default = 0. Can be 0, 1 or -1. 0 is for  testing both
directions of effect. 1 is for testing cases<controls and -1 is for
testing cases>controls.}

\item{flatten}{Default = 0.5. Numeric value recommended between 0 and 1.
If weights are not given, we take the max of flatten and the absolute
value of the Z-score of \code{x} as the weights (Default behavior).}

\item{ignoremax}{Default=0. Optional value indicating if we should ignore
the first few values when selecting the maximal enrichment score. Alternatively,
it can be viewed as the minimal size considered for the aberrant interval.}

\item{normmethod}{Default=1. If w=NULL the weights are generated by
subtracting the mean and dividing by the standard deviation. If \code{normmethod=2}, the
median and MAD are used instead, for a better treatment of outliers.}

\item{novariance}{Default=FALSE. aziz.test is able to detect a difference in
variance between cases and controls as an association (when variance of cases
is larger than the variance of controls). \code{novariance=True} changes the behaviour
and penalizes scenarios with outliers going both ways in the cases. This will
remove the associations that would usually be picked by a Levene test.
Consider using this when using unidirectional testing if variance changes between
groups are irrelevant in your considered problem. Results in loss of power.}
}
\value{
A vector that can be used in \code{get_calibrated_pvalues()}
}
\description{
Compute the null distribution of test statistics on one gaussian variable.
Useful if testing a large number of variables at once since it allows
  running permutations only once beforehand rather than for every variable.
  Used in conjunction with "\code{get_calibrated_pvalues}"
}
\examples{
y = c(rep(1,200),rep(0,200))
x = rnorm(400)
calibration = calibrate_test(y,rep=100)
es = aziz.test(y,x,rep=0)$es #No need for permutations, pvalues computed from calibration
get_calibrated_pvalues(calibration,es)

}
\seealso{
\code{\link{get_calibrated_pvalues}}, \code{\link{aziz.test}}
}
