% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enable_kms_key.R
\name{enable_kms_key}
\alias{enable_kms_key}
\alias{disable_kms_key}
\title{Enable/Disable Encryption Key}
\usage{
enable_kms_key(key, ...)

disable_kms_key(key, ...)
}
\arguments{
\item{key}{A character string specifying a key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with \dQuote{alias/}.}

\item{\dots}{Additional arguments passed to \code{\link{kmsHTTP}}.}
}
\description{
Enable or disable a KMS encryption key
}
\examples{
\dontrun{
  # create key
  k <- create_kms_key(description = "example")
  
  # disable key
  disable_kms_key(k)
  
  # enable key
  enable_kms_key(k)
  
  # delete in 7 days
  delete_kms_key(k)
}
}
\seealso{
\code{\link{create_kms_key}}, \code{\link{list_kms_keys}}
}
