% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_kms_alias.R
\name{create_kms_alias}
\alias{create_kms_alias}
\alias{delete_kms_alias}
\alias{update_kms_alias}
\alias{list_kms_aliases}
\title{Create/Delete KMS Key Alias}
\usage{
create_kms_alias(key, alias, ...)

delete_kms_alias(alias, ...)

update_kms_alias(key, alias, ...)

list_kms_aliases(n, marker, ...)
}
\arguments{
\item{key}{A character string specifying a key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with \dQuote{alias/}.}

\item{alias}{A character string specifying an alias name.}

\item{\dots}{Additional arguments passed to \code{\link{kmsHTTP}}.}

\item{n}{For \code{list_kms_alises}, an integer specifying a number of keys to return (for pagination).}

\item{marker}{For \code{list_kms_alises}, a pagination marker.}
}
\description{
Manage KMS key aliases.
}
\details{
\code{create_kms_alias} creates an alias for KMS key, which can be used in place of the KeyId or ARN. A given key can have multiple aliases. \code{delete_kms_alias} deletes an named alias. \code{update_kms_alias} reassigns an alias to a new key.
}
\seealso{
\code{\link{create_kms_key}}, \code{\link{delete_kms_key}}, \code{\link{encrypt}}
}
