% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_fpga_image_attribute}
\alias{ec2_modify_fpga_image_attribute}
\title{Modify Fpga Image Attribute}
\usage{
ec2_modify_fpga_image_attribute(
  FpgaImageId,
  DryRun = NULL,
  Attribute = NULL,
  OperationType = NULL,
  UserId = NULL,
  UserGroup = NULL,
  ProductCode = NULL,
  LoadPermission = NULL,
  Description = NULL,
  Name = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{FpgaImageId}{Character. The ID of the AFI.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Attribute}{Character. The name of the attribute.[optional]}

\item{OperationType}{Character. The operation type.[optional]}

\item{UserId}{List. The AWS account IDs. This parameter is valid only when modifying the \code{loadPermission} attribute.[optional]}

\item{UserGroup}{List. The user groups. This parameter is valid only when modifying the \code{loadPermission} attribute.[optional]}

\item{ProductCode}{List. The product codes.[optional]}

\item{LoadPermission}{Object. The load permission for the AFI.[optional]}

\item{Description}{Character. A description for the AFI.[optional]}

\item{Name}{Character. A name for the AFI.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modifies the specified attribute of the specified
Amazon FPGA Image (AFI).
}
\section{FpgaImageId}{

The ID of the AFI.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{Attribute}{

The name
of the attribute.
}

\section{OperationType}{

The operation
type.
}

\section{UserId}{

The AWS account IDs. This parameter is valid
only when modifying the \code{loadPermission}
attribute.
}

\section{UserGroup}{

The user groups. This parameter is valid
only when modifying the \code{loadPermission}
attribute.
}

\section{ProductCode}{

The product codes. After you add a
product code to an AFI, it can\'t be removed. This parameter is valid
only when modifying the \code{productCodes}
attribute.
}

\section{LoadPermission}{

The load permission for the
AFI.
}

\section{Description}{

A description for the
AFI.
}

\section{Name}{

A name for the AFI.
}

