% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpn_connection}
\alias{ec2_modify_vpn_connection}
\title{Modify Vpn Connection}
\usage{
ec2_modify_vpn_connection(
  VpnConnectionId,
  TransitGatewayId = NULL,
  CustomerGatewayId = NULL,
  VpnGatewayId = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpnConnectionId}{String. The ID of the VPN connection.}

\item{TransitGatewayId}{String. The ID of the transit gateway.[optional]}

\item{CustomerGatewayId}{String. The ID of the customer gateway at your end of the VPN connection.[optional]}

\item{VpnGatewayId}{String. The ID of the virtual private gateway at the AWS side of the VPN connection.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Vpn Connection
}
\section{VpnConnectionId}{

The ID of the VPN
connection.
}

\section{TransitGatewayId}{

The ID of the transit
gateway.
}

\section{CustomerGatewayId}{

The ID of the customer gateway at your end
of the VPN connection.
}

\section{VpnGatewayId}{

The ID of the virtual private
gateway at the AWS side of the VPN
connection.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

