% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpc_tenancy}
\alias{ec2_modify_vpc_tenancy}
\title{Modify Vpc Tenancy}
\usage{
ec2_modify_vpc_tenancy(
  VpcId,
  InstanceTenancy,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcId}{String. The ID of the VPC.}

\item{InstanceTenancy}{String. The instance tenancy attribute for the VPC.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Vpc Tenancy
}
\section{VpcId}{

The ID of the
VPC.
}

\section{InstanceTenancy}{

The instance tenancy attribute for the VPC.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

