% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_instance_credit_specifications}
\alias{ec2_describe_instance_credit_specifications}
\title{Describe Instance Credit Specifications}
\usage{
ec2_describe_instance_credit_specifications(
  DryRun = NULL,
  Filter = NULL,
  InstanceId = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{InstanceId}{List.   The instance IDs.[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Instance Credit Specifications
}
\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{Filter}{


The filters.
\itemize{
\item \code{instance-id} - The ID of the instance.
}
}

\section{InstanceId}{


The instance IDs.

Default: Describes all your instances.

Constraints: Maximum 1000 explicitly specified instance IDs.
}

\section{MaxResults}{

The maximum number of results to return in a single
call. To retrieve the remaining results, make another call with the
returned \code{NextToken} value. This value can be between 5 and 1000. You
cannot specify this parameter and the instance IDs parameter in the same
call.
}

