% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_client_vpn_endpoints}
\alias{ec2_describe_client_vpn_endpoints}
\title{Describe Client Vpn Endpoints}
\usage{
ec2_describe_client_vpn_endpoints(
  ClientVpnEndpointId = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  Filter = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ClientVpnEndpointId}{List. The ID of the Client VPN endpoint.[optional]}

\item{MaxResults}{Integer. The maximum number of results to return for the request in a single page.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more Client VPN endpoints
in the account.
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN
endpoint.
}

\section{MaxResults}{

The maximum number of results to return
for the request in a single page. The remaining results can be seen by
sending another request with the nextToken
value.
}

\section{Filter}{


One or more filters. Filter names and values are case-sensitive.
\itemize{
\item \code{endpoint-id} - The ID of the Client VPN endpoint.
\item \code{transport-protocol} - The transport protocol (\code{tcp} \| \code{udp}).
}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

