% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse_categories.R
\name{browse_categories}
\alias{browse_categories}
\title{Browse Categories}
\usage{
browse_categories(path = NULL, response_group = "Categories",
  description = TRUE, ...)
}
\arguments{
\item{path}{String; Required; valid category path}

\item{response_group}{String; Required; One of the following: Categories, RelatedCategories, LanguageCategories, LetterBars}

\item{description}{Boolean; Optional; Whether or not to return descriptions of categories; Default is TRUE}

\item{\dots}{Additional arguments passed to \code{\link{alexa_GET}}.}
}
\value{
data.frame with 5 columns: path, title, sub_category_count, total_listing_count, description
}
\description{
Uses data from \url{http://www.dmoz.org}
}
\examples{
\dontrun{
browse_categories(path="Top/Arts")
}
}
\references{
\url{http://docs.aws.amazon.com/AlexaWebInfoService/latest/index.html?ApiReference_CategoryBrowseAction.html}
}

