% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-options.R
\name{awdb_options}
\alias{awdb_options}
\alias{set_options}
\alias{print.awdb_options}
\title{Build List of Additional Query Parameters}
\usage{
set_options(
  networks = "*",
  duration = "daily",
  begin_date = NULL,
  end_date = NULL,
  period_reference = "end",
  central_tendency = NULL,
  return_flags = FALSE,
  return_original_values = FALSE,
  return_suspect_values = FALSE,
  begin_publication_date = NULL,
  end_publication_date = NULL,
  exceedence_probabilities = NULL,
  forecast_periods = NULL,
  station_names = NULL,
  dco_codes = NULL,
  county_names = NULL,
  hucs = NULL,
  return_forecast_metadata = FALSE,
  return_reservoir_metadata = FALSE,
  return_element_metadata = FALSE,
  active_only = TRUE,
  request_size = 10L
)

\method{print}{awdb_options}(x, ...)
}
\arguments{
\item{networks}{character vector, abbreviations or codes for station networks
of interest (e.g., "USGS" refers to all USGS soil monitoring stations).
Default is \code{*}, for "all networks". See Details for available networks and
codes.}

\item{duration}{character scalar, the temporal resolution of the element
measurements. Available values include \code{daily} (default), \code{hourly},
\code{semimonthly}, \code{monthly}, \code{calendar_year}, and \code{water_year}.}

\item{begin_date}{character scalar, start date for time period of interest.
Date must be in format \code{"YYYY-MM-DD"}.}

\item{end_date}{character scalar, end date for time period of interest. Date
must be in format \code{"YYYY-MM-DD"}.}

\item{period_reference}{character scalar, reporting convention to use when
returning instantaneous data. Default is \code{"end"}.}

\item{central_tendency}{character scalar, the central tendency to return for
each element value. Available options include \code{NULL} (default, no central
tendency returned), \code{median} and \code{average}.}

\item{return_flags}{boolean scalar, whether to return flags with each element
value. Default is \code{FALSE}.}

\item{return_original_values}{boolean scalar, whether to return original
element values. Default is \code{FALSE}.}

\item{return_suspect_values}{boolean scalar, whether to return suspect element
values. Default is \code{FALSE}.}

\item{begin_publication_date}{character scalar, the beginning of the
publication period for which to retrieve data. Date must be in format
\code{YYYY-MM-DD}. If \code{NULL}, assumes start of the current water year.}

\item{end_publication_date}{character scalar, the end of the publication
period for which to retrieve data. Date must be in format \code{YYYY-MM-DD}. If
\code{NULL}, assumes current day.}

\item{exceedence_probabilities}{integer vector, the probability that
streamflow will exceed a specified level.}

\item{forecast_periods}{character vector, the time period over which to make
streamflow forecasts.}

\item{station_names}{character vector, used to subset stations by their
names. Default is \code{NULL}.}

\item{dco_codes}{character vector, used to subset stations to those that fall
in specified DCOs. Default is \code{NULL}.}

\item{county_names}{character vector, used to subset stations to those that
fall in specified counties. Default is \code{NULL}.}

\item{hucs}{integer vector, used to subset stations to those that fall in
specified hydrologic units. Default is \code{NULL}.}

\item{return_forecast_metadata}{boolean scalar, whether to return forecast
metadata with station locations. Will be included as a list column. Default
is \code{FALSE}.}

\item{return_reservoir_metadata}{boolean scalar, whether to return reservoir
metadata with station locations. Will be included as a list column. Default
is \code{FALSE}.}

\item{return_element_metadata}{boolean scalar, whether to return element
metadata with station locations. Will be included as a list column. Default
is \code{FALSE}.}

\item{active_only}{boolean scalar, whether to include only active stations.
Default is \code{TRUE}.}

\item{request_size}{integer scalar, number of individual stations to include
in each query. This helps to meet rate limits imposed by the API. If you are
getting a request error, you might try lowering this number. Default is
\code{10L}.}

\item{x}{an \code{awdb_options} list}

\item{...}{ignored}
}
\value{
an \code{awdb_options} list
}
\description{
This is a helper function to make it easier to handle additional query
parameters. Provides defaults for each and does type checking.
}
\examples{
set_options()

}
