% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_phenotype_id_from_logic_operation.R
\name{get_phenotype_id_from_logic_operation}
\alias{get_phenotype_id_from_logic_operation}
\title{Get phenotype from logic operations}
\usage{
get_phenotype_id_from_logic_operation(
  logic_operation,
  phenotype_binary = FALSE,
  triplestore
)
}
\arguments{
\item{logic_operation}{List of logical functions from the following set:
"equals", "exclusive-or", "not-or", "and-not", "or", "orn-not", "and",
"not-and", "not".}

\item{phenotype_binary}{Logical value (TRUE/FALSE) to show/hide the phenotype in binary notation (FALSE by default).}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame. Columns: "phenotype_id", "phenotype_binary" (optional).
}
\description{
Get the phenotype encoded by the genome of a digital organism that is specified by a unique combination of logic operations.
}
\examples{

# Create triplestore object
triplestore <- triplestore_access$new()

# Set access options
triplestore$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single logic operation
get_phenotype_id_from_logic_operation(
  logic_operation = "not-or",
  triplestore = triplestore
)

# More than one logic operation
ops <- c("equals", "exclusive or", "not-or", "and-not", "or", "orn-not")

get_phenotype_id_from_logic_operation(
  logic_operation = ops,
  phenotype_binary = TRUE,
  triplestore = triplestore
)

}
