% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genome_seq_from_genome_id.R
\name{get_genome_seq_from_genome_id}
\alias{get_genome_seq_from_genome_id}
\title{Get genome sequence from genome}
\usage{
get_genome_seq_from_genome_id(genome_id, triplestore)
}
\arguments{
\item{genome_id}{Integer or a list of integer values.}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame. Columns: "genome_id" "genome_seq"
}
\description{
Get the linear string of letters representing the instruction
codes that make up the genome of a digital organism from the id of the genome
of a digital organism.
}
\examples{

# Create triplestore object
triplestore <- triplestore_access$new()

# Set access options
triplestore$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single genome
get_genome_seq_from_genome_id(1, triplestore = triplestore)

# More than one genome
get_genome_seq_from_genome_id(
  genome_id = c(1, 2, 3, 4),
  triplestore = triplestore
)

}
