% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transcriptome_id_from_genome_id.R
\name{get_transcriptome_id_from_genome_id}
\alias{get_transcriptome_id_from_genome_id}
\title{Get transcriptome from genome}
\usage{
get_transcriptome_id_from_genome_id(
  genome_id,
  seed_id = FALSE,
  transcriptome_seq = FALSE,
  transcriptome_pos = FALSE,
  genome_seq = FALSE
)
}
\arguments{
\item{genome_id}{Integer or list of integer values.}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer
values, or a logical value. This integer is used for starting the
pseudo-random number generator that represents the environment experiencing a
digital organism. If a logical value is used, TRUE returns data found in all
environments and FALSE (by default) returns only distinct data regardless of
the seed.}

\item{transcriptome_seq}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{transcriptome_pos}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{genome_seq}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}
}
\value{
Data frame. Columns: "seed_id" (optional), "genome_id", "genome_seq"
(optional), "transcriptome_id", "transcriptome_seq" (optional),
"transcriptome_pos" (optional).
}
\description{
Get the transcriptome of a digital organism having a specific
genome for a list of seeds used for starting the pseudo-random number
generator (i.e., a set of environments).
}
\examples{

# Singel genome
get_transcriptome_id_from_genome_id(genome_id = 1)

# More than one genome
get_transcriptome_id_from_genome_id(
  genome_id = c(1, 2),
  transcriptome_seq = TRUE
)

# At seed_1 and seed_3
get_transcriptome_id_from_genome_id(
  genome_id = 2,
  seed_id = c(1, 3),
  transcriptome_pos = TRUE
)

}
