% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_logic_operation_from_phenotype_id.R
\name{get_logic_operation_from_phenotype_id}
\alias{get_logic_operation_from_phenotype_id}
\title{Get the logic operations computed by a digital organism whose genome
encodes a specific phenotype}
\usage{
get_logic_operation_from_phenotype_id(
  phenotype_id = FALSE,
  phenotype_binary = FALSE
)
}
\arguments{
\item{phenotype_id}{Integer, a vector of integers (from 0 to 511), or a
logical value (if FALSE, the function returns the entire phenotype space).}

\item{phenotype_binary}{Logical value (TRUE/FALSE) to show/hide
phenotype_id in binary notation (FALSE by default).}
}
\value{
Data frame. Columns: "phenotype_id", "phenotype_binary" (optional),
"equals", "exclusive-or", "not-or", "and-not", "or", "orn-not", "and",
"not-and", "not"
}
\description{
Get the logic operations encoded by a digital organism having
the requested phenotype.
}
\examples{

# One phenotype
get_logic_operation_from_phenotype_id(
  phenotype_id = 1,
  phenotype_binary = TRUE
)

# More than one phenotype
get_logic_operation_from_phenotype_id(
  phenotype_id = c(1,2,3),
  phenotype_binary = TRUE
)

# All phenotypes
get_logic_operation_from_phenotype_id()

}
