% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/residual_outliers.r
\name{residual_outliers}
\alias{residual_outliers}
\title{Calculate dummy variables to mask residual outliers}
\usage{
residual_outliers(resid_matrix, number_of_rows)
}
\arguments{
\item{resid_matrix}{A matrix of residuals. Column names are copied over to the returned result.}

\item{number_of_rows}{The number of measurements that were input to the model. Since the length of the residual matrix is shorter depending on the amount of lags in the model, we use \code{number_of_rows} to specify the number of rows in the returned matrix.}
}
\value{
A matrix with dummy variables in columns following the procedure described above.
}
\description{
This function returns a matrix with columns that have a \code{1} at indices where the residuals have an outlier, and a \code{0} everywhere else. Outliers are calculated per variable (column) separately. We consider residual outliers the rows in the column of residuals or in the column of squared residuals that are more than 2.5 times the standard deviation away from the mean (standard deviation and mean are calculated separately per column and for residuals/squared residuals). The dummy columns are prepended with zeros to match the size of the other input variables to the model.
}
\examples{
resid_matrix <- matrix(rnorm(39 * 3),
                       nrow = 39,
                       ncol = 3,
                       dimnames = list(NULL, c('rumination', 'happiness', 'activity')))
resid_matrix[13, 2] <- 48
resid_matrix[23, 2] <- -62
resid_matrix[36, 2] <- 33
resid_matrix[27, 3] <- 75
resid_matrix
autovarCore:::residual_outliers(resid_matrix, 40)
}

