% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_constraints.R
\name{stsm_constraints}
\alias{stsm_constraints}
\title{Set the inequality constraints for estimation}
\usage{
stsm_constraints(
  prior,
  par,
  freq,
  unconstrained,
  det_trend,
  det_drift,
  det_cycle,
  det_seas,
  det_obs,
  saturating_growth
)
}
\arguments{
\item{prior}{A data table created by stsm_prior}

\item{par}{parameter values for the state space model}

\item{freq}{Frequency of the data}

\item{unconstrained}{Whether to remove inequality constraints on the trend during estimation}

\item{det_trend}{Set the trend error variance to 0 (deterministic trend)}

\item{det_drift}{Set the drift error variance to 0 (deterministic drift)}

\item{det_cycle}{Set the cycle error variance to 0 (deterministic cycle)}

\item{det_seas}{Set the seasonality error variances to 0 (deterministic seasonality)}

\item{det_obs}{Set the observation equation error variance to 0 (deterministic observation equation)}

\item{saturating_growth}{Force the growth rate to converge to 0 in the long term}
}
\value{
list containing the initial values for the Kalman filter
}
\description{
Inequality constraints: ineqA %*% par + ineqB > 0 => ineqA %*% par > -ineqB
}
