% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_detect_anomalies.R
\name{stsm_detect_anomalies}
\alias{stsm_detect_anomalies}
\title{Detect Anomalies}
\usage{
stsm_detect_anomalies(
  model,
  y = NULL,
  freq = NULL,
  exo = NULL,
  sig_level = 0.01,
  smooth = TRUE,
  plot = FALSE
)
}
\arguments{
\item{model}{Structural time series model estimated using stsm_estimate.}

\item{y}{Univariate time series of data values. May also be a 2 column data frame containing a date column.}

\item{freq}{Frequency of the data (1 (yearly), 4 (quarterly), 12 (monthly), 365.25/7 (weekly), 365.25 (daily)), default is NULL and will be automatically detected}

\item{exo}{Matrix of exogenous variables used for the historical data. Can be used to specify regression effects or other seasonal effects like holidays, etc.}

\item{sig_level}{Significance level to determine statistically significant anomalies}

\item{smooth}{Whether or not to use the Kalman smoother}

\item{plot}{Whether to plot everything}
}
\value{
data table (or list of data tables) containing the dates of detected anomalies from the filtered and/or smoothed series
}
\description{
Detect anomalies using the estimated structural time series model
}
\examples{
\dontrun{
#GDP Not seasonally adjusted
library(autostsm)
data("NA000334Q", package = "autostsm") #From FRED
NA000334Q = data.table(NA000334Q, keep.rownames = TRUE)
colnames(NA000334Q) = c("date", "y")
NA000334Q[, "date" := as.Date(date)]
NA000334Q[, "y" := as.numeric(y)]
NA000334Q = NA000334Q[date >= "1990-01-01", ]
stsm = stsm_estimate(NA000334Q)
anomalies = stsm_detect_anomalies(model = stsm, y = NA000334Q, plot = TRUE)
}
}
