% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_cor.R
\name{auto_cor}
\alias{auto_cor}
\title{auto correlation}
\usage{
auto_cor(
  .data,
  ...,
  use = c("pairwise.complete.obs", "all.obs", "complete.obs", "everything",
    "na.or.complete"),
  method = c("pearson", "kendall", "spearman", "xicor"),
  include_nominals = TRUE,
  max_levels = 5L,
  sparse = TRUE,
  pval_thresh = 0.1
)
}
\arguments{
\item{.data}{data frame}

\item{...}{tidyselect cols}

\item{use}{method to deal with na. Default is to remove rows with NA}

\item{method}{correlation method. default is pearson, but also supports xicor.}

\item{include_nominals}{logicals, default TRUE. Dummify nominal variables?}

\item{max_levels}{maximum numbers of dummies to be created from nominal variables}

\item{sparse}{logical, default TRUE. Filters and arranges cor table}

\item{pval_thresh}{threshold to filter out weak correlations}
}
\value{
data frame of correlations
}
\description{
Finds the correlation between numeric variables in a data frame, chosen using tidyselect.
Additional parameters for the correlation test can be specified as in \code{\link[stats]{cor.test}}
}
\details{
includes the asymmetric correlation coefficient xi from \code{\link[XICOR]{xicor}}
}
\examples{

iris \%>\%
auto_cor()

# don't use sparse if you're interested in only one target variable
iris \%>\%
auto_cor(sparse = FALSE) \%>\%
dplyr::filter(x == "Petal.Length")
}
