% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_ctree.R
\name{tidy_ctree}
\alias{tidy_ctree}
\title{tidy ctree}
\usage{
tidy_ctree(.data, formula, minbucket = 7L, mincriterion = 0.95, ...)
}
\arguments{
\item{.data}{dataframe}

\item{formula}{formula}

\item{minbucket}{minimum amount of samples in terminal leaves, default is 7}

\item{mincriterion}{(1 - alpha)   value between 0 -1, default is .95. lowering this value creates more splits, but less significant}

\item{...}{optional parameters to \code{\link[party]{ctree_control}}}
}
\value{
a ctree object
}
\description{
tidy conditional inference tree. Creates easily interpretable decision tree models that be shown with the \code{\link{visualize_model}} function.
Statistical significance required for a split , and minimum necessary samples in a terminal leaf can be controlled to create the desired tree visual.
}
\examples{

iris \%>\%
tidy_formula(., Sepal.Length) -> sepal_form

iris \%>\%
tidy_ctree(sepal_form) \%>\%
visualize_model()

iris \%>\%
tidy_ctree(sepal_form, minbucket = 30) \%>\%
visualize_model(plot_type = "box")


}
