% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.scale.R
\name{legend.scale}
\alias{legend.scale}
\title{Color scale legend}
\usage{
legend.scale(zlim, col = viridisLite::viridis(12), horizontal = TRUE,
  breaks, axis.args)
}
\arguments{
\item{zlim}{A two-dimensional vector containing the minimum and 
maximum quantitative limits, respectively, for the color scale.}

\item{col}{A vector of colors used for the color scale. Typically, 
this is a gradient of colors. The default is the 12 colors 
generated by \code{viridisLite::viridis(12)}.}

\item{horizontal}{A logical value indicating whether the legend 
should extend horizontally (\code{TRUE}) or vertically 
(\code{FALSE}). The default is \code{TRUE}.}

\item{breaks}{The sequence of values defining the partition of 
\code{zlim}.  The length should be one more than then number of 
colors.  If not specified, then equidistant breaks are used.}

\item{axis.args}{A list of named elements corresponding to the 
arguments of the \code{\link[graphics]{axis}} function.  This is 
used to modify the appearance of the scale of the legend.  See 
Examples.}
}
\description{
\code{legend.scale} plots a color gradient with an associated 
quantitative scale.
}
\details{
The length of the \code{col} vector indicates the number of 
partitions for the quantitative range.
}
\examples{
# default horizontal scale
legend.scale(c(0, 1))

# default vertical scale
legend.scale(c(0, 1), horizontal = FALSE)

# different color scheme with 24 colors
legend.scale(c(0, 1), col = cm.colors(24))

# irregular color breaks
legend.scale(c(0, 1), col = heat.colors(4), 
             breaks = c(0, 0.5, 0.75, 0.875, 1))

# irregular color breaks with modified ticks and vertical 
# orientation of labels
legend.scale(c(0, 1), col = heat.colors(4),
             breaks = c(0, 0.5, 0.75, 0.875, 1),
             axis.args = list(at = c(0, 0.5, 0.75, 0.875, 1), las = 2))

# change size of axis labels
legend.scale(c(0, 1), axis.args = list(cex.axis = 2))

# change color of axis labels and ticks
blue.axes <- list(col.axis = "blue", col.ticks = "blue")
legend.scale(c(0, 1), axis.args = blue.axes)

# log base 10 values with colors labeled on original scale
options(scipen = 2)
log.axis <- list(at = 0:6, labels = 10^(0:6), las = 2)
legend.scale(c(0, 6), col = heat.colors(6), axis.args = log.axis)
}
\references{
The code for this function is derived from the 
  internals of the \code{\link[fields]{image.plot}} function 
  written by Doug Nychka and from the \code{image.scale} function 
  written by Marc Taylor and discussed at 
  \url{http://menugget.blogspot.com/2013/12/new-version-of-imagescale-function.html}.
}
\seealso{
\code{\link[graphics]{image}}, 
  \code{\link[fields]{image.plot}}, \code{\link[graphics]{axis}}
}
