% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unihdaftma.R
\name{unihdaftma}
\alias{unihdaftma}
\title{High dimensional competing risk analysis by univariate accelerated failure time model
       with mediation analysis}
\usage{
unihdaftma(m, n, survdur, event, ths, b, d, data)
}
\arguments{
\item{m}{Starting column number from where high dimensional variates to be selected.}

\item{n}{Ending column number till where high dimensional variates to be selected.}

\item{survdur}{"Column/Variable name" consisting duration of survival.}

\item{event}{"Column/Variable name" consisting survival event.}

\item{ths}{A numeric between 0 to 100.}

\item{b}{Number of MCMC iterations to burn.}

\item{d}{Number of draws.}

\item{data}{High dimensional data containing survival observations and high dimensional covariates.}
}
\value{
Data frame containing the beta and alpha values of active variables among the significant variables.
}
\description{
Given the dimension of variables and survival information risks the function
filters significant variables, allowing the user to fit univariate AFT model. Further, it performs mediation
analysis among the significant variables and provides handful variables with their alpha.a values
which are mediator model exposure coefficients and beta.a coefficients.
}
\examples{
##
data(hnscc)
unihdaftma(m=8,n=80,survdur="os",event="death",ths=0.5,b=1000,d=10,data=hnscc2)
##
}
