% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocart.R
\name{autotune}
\alias{autotune}
\title{Find the best alpha, beta, and bandwidth values with k-fold cross-validation}
\usage{
autotune(
  response,
  data,
  locations,
  k = 8,
  control = NULL,
  customGroups = NULL,
  alphaVals = NULL,
  betaVals = NULL,
  bandwidthVals = NULL,
  outputProgress = FALSE,
  useSpatialNodes = FALSE,
  spatialNodesMethod = "idw",
  spatialNodesDistPower = 2,
  spatialNodesDistPowerRange = c(0, 2),
  spatialNodesModelByResidual = FALSE
)
}
\arguments{
\item{response}{The vector of response values to test on.}

\item{data}{The data frame of predictor variables.}

\item{locations}{The n by 2 matrix of coordinate information for the known observations}

\item{k}{The number of folds to create in k-fold cross-validation for tuning}

\item{control}{An optional control function to send to the autocart creation function}

\item{customGroups}{Here, you may supply custom groups for cross-validation. This parameter must be supplied as a factor and labeled from 1:numLevels.}

\item{alphaVals}{Override the alpha values that are expanded in the grid in this function.}

\item{betaVals}{Override the beta values that are expanded in the grid in this function.}

\item{bandwidthVals}{Override the bandwidth values that are expanded in the grid in this function.}

\item{outputProgress}{Print the result of the cross-validations as you are going. This is useful when the cross-validation will be very long and you do not wish to wait.}

\item{useSpatialNodes}{Use an interpolative process at the terminal nodes of the autocart tree for the prediction process}

\item{spatialNodesMethod}{The type of interpolation to use at the terminal nodes}

\item{spatialNodesDistPower}{The power parameter to use in inverse distance weighting at terminal nodes}

\item{spatialNodesDistPowerRange}{The ranged power parameter p1, p2 to use for a varying power parameter}

\item{spatialNodesModelByResidual}{Do the interpolative process on the residuals of the prediction formed by response average at terminal nodes}
}
\value{
A list of the labeled optimal parameters that were chosen for the best predictive accuracy on cross-validation.
}
\description{
Find the best alpha, beta, and bandwidth values with k-fold cross-validation
}
\examples{
# Load some data for an autotune example
# (Note that a low sample size is used here for quick example computation.
#  In a practical application this function can be quite computationally
#  demanding due to the grid-search nature of the function.)
snow <- na.omit(read.csv(system.file("extdata", "ut2017_snow.csv", package = "autocart")))
y <- snow$yr50[1:35]
X <- data.frame(snow$ELEVATION, snow$MCMT, snow$PPTWT)[1:35, ]
locations <- as.matrix(cbind(snow$LONGITUDE, snow$LATITUDE))[1:35, ]

# Find optimal parameters via cross-validation. We'll search through the
# following alpha/beta/bandwidth values:
alphaVec <- c(0.0, 0.5)
betaVec <- c(0.0, 0.2)
bandwidthVec <- c(1.0)

# We'll find the optimal values with 5-fold cross validation:
# (Due to the large number of cross-validations and trainings that occur,
# this can take a few minutes.)
myTune <- autotune(y, X, locations, k = 3, alphaVals = alphaVec,
                   betaVals = betaVec, bandwidthVals = bandwidthVec)
# Inspect the results
myTune

}
