% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bins_tree.R
\name{bins_tree}
\alias{bins_tree}
\title{Automatic Binning Based on Decision Tree
Automatic Binning Based on  Decision Tree(rpart).}
\usage{
bins_tree(df, key_var, y_var, max_depth = 3, p = 0.1)
}
\arguments{
\item{df}{A data.frame with independent variables and target variable.}

\item{key_var}{A name of index variable name.}

\item{y_var}{A name of target variable.}

\item{max_depth}{Set the maximum depth of any node of the final tree, with the root node counted as depth 0. Values greater than 30 rpart will give nonsense results on 32-bit machines.}

\item{p}{Meet the following conversion formula: minbucket = round(p*nrow(df)).Smallest bucket(rpart):Minimum number of observations in any terminal <leaf> node.}
}
\value{
A data frame, including the contents of the bin, the upper bound of the bin, the lower bound of the bin, and all the contents returned by the get_IV function.
}
\description{
Automatic Binning Based on Decision Tree
Automatic Binning Based on  Decision Tree(rpart).
}
\examples{
accepts <- read.csv(system.file( "extdata", "accepts.csv", package = "autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
all2 <- bins_tree(df = feature, key_var= "application_id", y_var= "bad_ind"
, max_depth = 3, p = 0.1 )
}
