% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-ebird-taxonomy.r
\name{get_ebird_taxonomy}
\alias{get_ebird_taxonomy}
\title{Get eBird taxonomy via the eBird API}
\usage{
get_ebird_taxonomy(version, locale)
}
\arguments{
\item{version}{integer; the version (i.e. year) of the taxonomy. The eBird
taxonomy is updated once a year in August. Leave this parameter blank to
get the current taxonomy.}

\item{locale}{character; the \href{http://help.ebird.org/customer/portal/articles/1596582-common-name-translations-in-ebird}{locale for the common names},
defaults to English.}
}
\value{
A data frame of all species in the eBird taxonomy, consisting of the
following columns:
\itemize{
\item \code{scientific_name}: scientific name.
\item \code{common_name}: common name, defaults to English, but different languages
can be selected using the \code{locale} parameter.
\item \code{species_code}: a unique alphanumeric code identifying each species.
\item \code{category}: whether the entry is for a species or another
field-identifiable taxon, such as \code{spuh}, \code{slash}, \code{hybrid}, etc.
\item \code{taxon_order}: numeric value used to sort rows in taxonomic order.
\item \code{order}: the scientific name of the order that the species belongs to.
\item \code{family}: the scientific name of the family that the species belongs to.
\item \code{report_as}: for taxa that can be resolved to true species (i.e. species,
subspecies, and recognizable forms), this field links to the corresponding
species code. For taxa that can't be resolved, this field is \code{NA}.
}
}
\description{
Get the taxonomy used in eBird via the eBird API.
}
\examples{
\dontrun{
get_ebird_taxonomy()
}
}
\seealso{
Other helpers: \code{\link{auk_ebd_version}},
  \code{\link{auk_version}}, \code{\link{ebird_species}}
}
\concept{helpers}
