% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-distance.r
\name{auk_distance}
\alias{auk_distance}
\title{Filter eBird data by distance travelled}
\usage{
auk_distance(x, distance, distance_units)
}
\arguments{
\item{x}{\code{auk_ebd} object; reference to object created by \code{\link[=auk_ebd]{auk_ebd()}}.}

\item{distance}{integer; 2 element vector specifying the range of distances
to filter by. The default is to accept distances in kilometers, use
\code{distance_units = "miles"} for miles.}

\item{distance_units}{character; whether distances are provided in kilometers
(the default) or miles.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on the distance
travelled on the checklist. This function only defines the filter and, once
all filters have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and
perform the filtering. Note that stationary checklists (i.e. point counts)
have no distance associated with them, however, since these checklists can
be assumed to have 0 distance they will be kept if 0 is in the range defined
by \code{distance}.
}
\examples{
# only keep checklists that are less than 10 km long
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_distance(distance = c(0, 10))
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_distance(ebd, distance = c(0, 10))
}
