% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.auditor_model_residual}
\alias{print.auditor_model_residual}
\title{Prints Model Residual Summary}
\usage{
\method{print}{auditor_model_residual}(x, ...)
}
\arguments{
\item{x}{an object \code{auditor_model_residual} created with \code{\link{model_residual}} function.}

\item{...}{other parameters}
}
\description{
Prints Model Residual Summary
}
\examples{
data(titanic_imputed, package = "DALEX")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

glm_audit <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
model_residual(glm_audit)

}
