% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_scalelocation.R
\name{plotD3_scalelocation}
\alias{plotD3_scalelocation}
\alias{plotD3ScaleLocation}
\title{Scale Location Plot in D3 with r2d3 package.}
\usage{
plotD3_scalelocation(
  object,
  ...,
  variable = NULL,
  smooth = FALSE,
  peaks = FALSE,
  point_count = NULL,
  single_plot = TRUE,
  scale_plot = FALSE,
  background = FALSE
)

plotD3ScaleLocation(
  object,
  ...,
  variable = NULL,
  smooth = FALSE,
  peaks = FALSE,
  point_count = NULL,
  single_plot = TRUE,
  scale_plot = FALSE,
  background = FALSE
)
}
\arguments{
\item{object}{An object of class \code{auditor_model_residual} created with \code{\link{model_residual}} function.}

\item{...}{Other \code{auditor_model_residual} objects to be plotted together.}

\item{variable}{Name of variable to order residuals on a plot.
If \code{variable="_y_"}, the data is ordered by a vector of actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).
If \code{variable = "_y_hat_"} the data on the plot will be ordered by predicted response.
If \code{variable = NULL}, unordered observations are presented.}

\item{smooth}{Logical, indicates whenever smoothed lines should be added. By default it's \code{FALSE}.}

\item{peaks}{Logical, indicates whenever peak observations should be highlighted. By default it's \code{FALSE}.}

\item{point_count}{Number of points to be plotted per model. Points will be chosen randomly. By default plot all of them.}

\item{single_plot}{Logical, indicates whenever single or facets should be plotted. By default it's \code{TRUE}.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's \code{FALSE}.}

\item{background}{Logical, available only if single_plot = FALSE. Indicates whenever background plots should be plotted. By default it's FALSE.}
}
\value{
a \code{r2d3} object
}
\description{
Function \code{plotD3_scalelocation} plots square root of the absolute value of the residuals vs target,
observed or variable values in the model. A vertical line corresponds to median.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)

# plot results
plotD3_scalelocation(mr_lm, peaks = TRUE)

}
\seealso{
\code{\link{plot_scalelocation}}
}
