% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_residual_boxplot.R
\name{plot_residual_boxplot}
\alias{plot_residual_boxplot}
\alias{plotResidualBoxplot}
\title{Plot Boxplots of Residuals}
\usage{
plot_residual_boxplot(object, ...)

plotResidualBoxplot(object, ...)
}
\arguments{
\item{object}{An object of class \code{auditor_model_residual}
created with \code{\link{model_residual}} function.}

\item{...}{Other \code{auditor_model_residual} objects to be plotted together.}
}
\value{
A ggplot object.
}
\description{
A boxplot of residuals.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)

# plot results
plot_residual_boxplot(mr_lm)
plot(mr_lm, type = "residual_boxplot")

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
rf_audit <- audit(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(rf_audit)
plot_residual_boxplot(mr_lm, mr_rf)
plot(mr_lm, mr_rf)

}
\seealso{
\code{\link{plot_residual}}
}
