% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lift.R
\name{plot_lift}
\alias{plot_lift}
\alias{plotLIFT}
\title{LIFT Chart}
\usage{
plot_lift(object, ..., zeros = TRUE)

plotLIFT(object, ...)
}
\arguments{
\item{object}{An object of class \code{auditor_model_evaluation} created with \code{\link{model_evaluation}} function.}

\item{...}{Other \code{auditor_model_evaluation} objects to be plotted together.}

\item{zeros}{Logical. It makes the lines start from the \code{(0,0)} point. By default it's \code{TRUE}.}
}
\value{
A ggplot object.
}
\description{
LIFT is a plot of the rate of positive prediction against true positive rate for the different thresholds.
It is useful for measuring and comparing the accuracy of the classificators.
}
\examples{
data(titanic_imputed, package = "DALEX")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

glm_audit <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
eva_glm <- model_evaluation(glm_audit)

# plot results
plot_lift(eva_glm)
plot(eva_glm, type ="lift")

model_glm_2 <- glm(survived ~ .-age, family = binomial, data = titanic_imputed)
glm_audit_2 <- audit(model_glm_2,
                     data = titanic_imputed,
                     y = titanic_imputed$survived,
                     label = "glm2")
eva_glm_2 <- model_evaluation(glm_audit_2)

plot_lift(eva_glm, eva_glm_2)
plot(eva_glm, eva_glm_2, type = "lift")


}
\seealso{
\code{\link{model_evaluation}}
}
