% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_halfnormal.R
\name{plot_halfnormal}
\alias{plot_halfnormal}
\alias{plotHalfNormal}
\title{Half-Normal plot}
\usage{
plot_halfnormal(object, ..., quantiles = FALSE, sim = 99)

plotHalfNormal(object, ..., quantiles = FALSE, sim = 99)
}
\arguments{
\item{object}{An object of class \code{auditor_model_halfnormal} created with \code{\link{model_halfnormal}} function.}

\item{...}{Other \code{auditor_model_halfnormal} objects.}

\item{quantiles}{If TRUE values on axis are on quantile scale.}

\item{sim}{Number of residuals to simulate.}
}
\value{
A ggplot object.
}
\description{
The half-normal plot is one of the tools designed to evaluate the goodness of fit of a
statistical models. It is a graphical method for comparing two probability distributions by plotting
their quantiles against each other.
Points on the plot correspond to ordered absolute values of model diagnostic
(i.e. standardized residuals) plotted against theoretical order statistics from a half-normal distribution.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
hn_lm <- model_halfnormal(lm_audit)

# plot results
plot_halfnormal(hn_lm)
plot(hn_lm)

}
\seealso{
\code{\link{model_halfnormal}}

\code{\link{score_halfnormal}}
}
