% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_residual.R
\name{plotD3_residual}
\alias{plotD3_residual}
\alias{plotD3Residual}
\title{Plot Residuals vs Observed, Fitted or Variable Values in D3 with r2d3 package.}
\usage{
plotD3_residual(
  object,
  ...,
  variable = "_y_",
  points = TRUE,
  smooth = FALSE,
  std_residuals = FALSE,
  nlabel = 0,
  point_count = NULL,
  single_plot = TRUE,
  scale_plot = FALSE,
  background = FALSE
)

plotD3Residual(
  object,
  ...,
  variable = NULL,
  points = TRUE,
  smooth = FALSE,
  std_residuals = FALSE,
  point_count = NULL,
  single_plot = TRUE,
  scale_plot = FALSE,
  background = FALSE
)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{Other 'auditor_model_residual' objects to be plotted together.}

\item{variable}{Name of variable to order residuals on a plot.
If \code{variable="_y_"}, the data is ordered by a vector of actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).
If \code{variable = "_y_hat_"} the data on the plot will be ordered by predicted response.
If \code{variable = NULL}, unordered observations are presented.}

\item{points}{Logical, indicates whenever observations should be added as points. By defaul it's TRUE.}

\item{smooth}{Logical, indicates whenever smoothed lines should be added. By default it's FALSE.}

\item{std_residuals}{Logical, indicates whenever standardized residuals should be used. By default it's FALSE.}

\item{nlabel}{Number of observations with the biggest residuals to be labeled.}

\item{point_count}{Number of points to be plotted per model. Points will be chosen randomly. By default plot all of them.}

\item{single_plot}{Logical, indicates whenever single or facets should be plotted. By default it's TRUE.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's FALSE.}

\item{background}{Logical, available only if single_plot = FALSE. Indicates whenever backgroud plots should be plotted.
By default it's FALSE.}
}
\value{
a \code{r2d3} object
}
\description{
Function \code{plotD3_residual} plots resudial values vs fitted, observed or variable values in the model.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)

# plot results
plotD3_residual(mr_lm)

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
rf_audit <- audit(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(rf_audit)
plotD3_residual(mr_lm, mr_rf)

}
\seealso{
\code{\link{plot_residual}}
}
