% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScaleLocation.R
\name{plotScaleLocation}
\alias{plotScaleLocation}
\title{Scale location plot}
\usage{
plotScaleLocation(object, ..., variable = NULL, score = FALSE,
  peaks = TRUE)
}
\arguments{
\item{object}{An object of class modelAudit or modelResiduals.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{variable}{Only for modelAudit object. Name of model variable to order residuals. If value is NULL data order is taken. If value is "Predicted response" or "Fitted values" then data is ordered by fitted values. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}

\item{score}{A logical value. If TRUE value of \link{scorePeak} will be added.}

\item{peaks}{A logical value. If TRUE peaks are marked on plot by black dots.}
}
\description{
Variable values vs square root of the absolute value of the residuals.
A vertical line corresponds to median.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotScaleLocation(lm_au)


}
