% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelPerformance.R
\name{modelPerformance}
\alias{modelPerformance}
\title{Create Model Performance Explainer}
\usage{
modelPerformance(object, scores = c("MAE", "MSE", "REC", "RROC"),
  new.score = NULL)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{scores}{Vector of score names to be plotted.}

\item{new.score}{A named list of functions that take one argument: object of class ModelAudit and return a numeric value. The measure calculated by the function should have the property that lower score value indicates better model.}

\item{...}{other parameters.}
}
\description{
Creates observationInfluence object to be plotted.
}
\examples{
library(MASS)
model.glm <- glm(Postwt ~ Prewt + Treat + offset(Prewt), family = gaussian, data = anorexia)
audit.glm <- audit(model.glm)

mp.glm <- modelPerformance(audit.glm)


}
