% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreGQ.R
\name{scoreGQ}
\alias{scoreGQ}
\title{Goldfeld-Quandt Score}
\usage{
scoreGQ(object, variable = NULL)
}
\arguments{
\item{object}{Object An object of class ModelAudit.}

\item{variable}{Name of model variable to order residuals. If value is NULL data order is taken. If value is "Predicted response" or "Fitted values" then data is ordered by fitted values. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}
}
\value{
an object of class scoreAudit
}
\description{
This score is calculated on the basis of Goldfeld-Quandt test, which is used for checking for homoscedasticity of residuals in regression analyses.

Goldfeld-Quandt test is based on a comparison of the residual sum of squares (RSS) using the F-statistic.
The test consists of dividing dataset into two groups. Then estimating models separately for each subset and calculating
the residual sum of squares for each group (RSS1 and RSS2).

The test statistic is the ratio of the mean square residual errors for two groups, which corresponds to the F-test of equality of variances.
\eqn{F = (MSE_1)/(MSE_2)}
where \eqn{MSE = (RSS)/(n-p)}
where n is the number of observations and p is the number of variables .

The score value is helpful in comparing models. It is worth pointing out that results of tests like p-value makes sense only
when the test assumptions are satisfied. Otherwise test statistic may be considered as a score.
\code{scoreGQ} function uses a two-sided F-test.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
scoreGQ(lm_au)

}
