% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warn_if.R
\name{stop_if}
\alias{stop_if}
\alias{stop_if_any}
\alias{stop_if_all}
\alias{stop_if_none}
\alias{stop_if_not}
\alias{warn_if}
\alias{warn_if_any}
\alias{warn_if_all}
\alias{warn_if_none}
\alias{warn_if_not}
\alias{message_if}
\alias{message_if_any}
\alias{message_if_all}
\alias{message_if_none}
\alias{message_if_not}
\title{Warn if}
\usage{
stop_if(.x, .p = isTRUE, msg = NULL)

stop_if_any(.l, .p = isTRUE, msg = NULL)

stop_if_all(.l, .p = isTRUE, msg = NULL)

stop_if_none(.l, .p = isTRUE, msg = NULL)

stop_if_not(.x, .p = isTRUE, msg = NULL)

warn_if(.x, .p = isTRUE, msg = NULL)

warn_if_any(.l, .p = isTRUE, msg = NULL)

warn_if_all(.l, .p = isTRUE, msg = NULL)

warn_if_none(.l, .p = isTRUE, msg = NULL)

warn_if_not(.x, .p = isTRUE, msg = NULL)

message_if(.x, .p = isTRUE, msg = NULL)

message_if_any(.l, .p = isTRUE, msg = NULL)

message_if_all(.l, .p = isTRUE, msg = NULL)

message_if_none(.l, .p = isTRUE, msg = NULL)

message_if_not(.x, .p = isTRUE, msg = NULL)
}
\arguments{
\item{.x}{the element to evaluate. If dot \code{.}, the}

\item{.p}{the predicate with the condition to test on \code{.x} or \code{.l}. Default is isTRUE.}

\item{msg}{the message to return. If NULL (default), the built-in message is printed.}

\item{.l}{the list of elements to evaluate}
}
\description{
Friendlier messaging functions
}
\examples{
\dontrun{
x <- 12
stop_if(x, is.numeric)
stop_if_not(x, is.character)

a  <- "this is not numeric"
warn_if(a,  is.character )
warn_if_not(a, is.numeric )
b  <- 20
warn_if(b ,  ~ . > 10 ,
         msg = "Wow, that's a lot of b")
c <- "a"
message_if(c, is.character,
         msg = "You entered a character element")
}
}
