% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.r
\name{post}
\alias{post}
\alias{post_skeet}
\alias{delete_skeet}
\alias{delete_post}
\title{Post a skeet}
\usage{
post(
  text,
  in_reply_to = NULL,
  quote = NULL,
  image = NULL,
  image_alt = NULL,
  created_at = Sys.time(),
  verbose = NULL,
  .token = NULL
)

post_skeet(
  text,
  in_reply_to = NULL,
  quote = NULL,
  image = NULL,
  image_alt = NULL,
  created_at = Sys.time(),
  verbose = NULL,
  .token = NULL
)

delete_skeet(post_url, verbose = NULL, .token = NULL)

delete_post(post_url, verbose = NULL, .token = NULL)
}
\arguments{
\item{text}{Text to post}

\item{in_reply_to}{URL or URI of a skeet this should reply to.}

\item{quote}{URL or URI of a skeet this should quote.}

\item{image}{path to an image to post}

\item{image_alt}{alt text for the image}

\item{created_at}{time stamp of the post}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). Package default (when \code{NULL}) is to have
status messages. Can be changed with \code{Sys.setenv(ATR_VERBOSE =
  FALSE)}.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}

\item{post_url}{URL or URI of post to delete}
}
\value{
list of the URI and CID of the post (invisible)
}
\description{
Post a skeet
}
\examples{
\dontrun{
post("Hello from #rstats with {atrrr}")
}
}
