
<!-- README.md is generated from README.Rmd. Please edit that file -->

# atrrr <img src="man/figures/logo.png" align="right" height="120">

<!-- badges: start -->

[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
[![R-CMD-check](https://github.com/JBGruber/atrrr/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/JBGruber/atrrr/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/JBGruber/atrrr/branch/main/graph/badge.svg)](https://app.codecov.io/gh/JBGruber/atrrr?branch=main)
[![say-thanks](https://img.shields.io/badge/Say%20Thanks-!-1EAEDB.svg)](https://saythanks.io/to/JBGruber)
<!-- badges: end -->

The goal of atrrr[^1] is to wrap the AT Protocol (Authenticated Transfer
Protocol) behind Bluesky. [*And we have actually already fulfilled this
goal!*](#want-to-help).

The entire protocol is open and documented in so-called
[lexicons](https://atproto.com/guides/lexicon), from which we
autogenerated `R` functions.

These are not exported, however, since dealing with them is a bit
advanced. Rather we have some nice human-generated functions with
documentation and examples.

## Installation

You can install the development version of `atrrr` like so (install the
`remotes` package first, with `install.packages("remotes")`, if you
don’t have that yet):

``` r
# install.packages("remotes")
remotes::install_github("JBGruber/atrrr")
```

## Load the package

``` r
library(atrrr)
```

## Authentication

The first time you make a request, you will be prompted automatically to
enter your user handle and an app password to authenticate `atrrr` to
communicate with BlueSky for you.

<figure>
<img src="vignettes/figures/password_popup.png" alt="RStudio Popup" />
<figcaption aria-hidden="true">RStudio Popup</figcaption>
</figure>

The page to generate app passwords is also automatically opened for you.

<figure>
<img src="vignettes/figures/app_password.png"
alt="page to create new app passwords" />
<figcaption aria-hidden="true">page to create new app
passwords</figcaption>
</figure>

However, you can also trigger this process manually:

``` r
auth("jbgruber.bsky.social")
```

This can be useful if you want to replace an old token as it is
permanently stored encrypted on disk.

## Retrieve Skeets (`get_skeets_authored_by`)

To fetch all the skeets by a specific user, use the
`get_skeets_authored_by` function. *Note this also includes quote skeets
and reskeets.* You can also opt not to parse the result by setting
`parse = FALSE`, however it is recommended to use the default parse
option which results in a (more) tidy tibble.

``` r
get_skeets_authored_by(actor = "benguinaudeau.bsky.social", parse = TRUE) |>
  dplyr::glimpse()
#> Rows: 25
#> Columns: 16
#> $ uri           <chr> "at://did:plc:vuvsifrusnjsys7mhkpk662u/app.bsky.feed.pos…
#> $ cid           <chr> "bafyreiegp7mni5p3njrgd52wl62jwjtbdxlms2ogzxaaod775tc6ri…
#> $ author_handle <chr> "benguinaudeau.bsky.social", "benguinaudeau.bsky.social"…
#> $ author_name   <chr> "Benjamin Guinaudeau", "Benjamin Guinaudeau", "David For…
#> $ text          <chr> "Genuinely opening a colleague's script to smoothly tran…
#> $ author_data   <list> ["did:plc:vuvsifrusnjsys7mhkpk662u", "benguinaudeau.bsk…
#> $ post_data     <list> ["Genuinely opening a colleague's script to smoothly tr…
#> $ embed_data    <list> ["app.bsky.embed.images#view", [["https://cdn.bsky.app/…
#> $ reply_count   <int> 0, 0, 4, 0, 1, 7, 0, 1, 0, 1, 0, 0, 0, 0, 1, 12, 0, 0, 1…
#> $ repost_count  <int> 0, 0, 15, 2, 1, 366, 3, 1, 4, 28, 0, 0, 0, 0, 0, 290, 14…
#> $ like_count    <int> 0, 1, 43, 6, 1, 498, 8, 3, 10, 34, 0, 0, 1, 4, 2, 455, 3…
#> $ indexed_at    <dttm> 2024-01-03 16:49:08, 2024-01-03 16:46:52, 2023-12-23 22…
#> $ in_reply_to   <chr> NA, "at://did:plc:eotrvt2wp6mqooxjf3bzklwa/app.bsky.feed…
#> $ in_reply_root <chr> NA, "at://did:plc:eotrvt2wp6mqooxjf3bzklwa/app.bsky.feed…
#> $ quotes        <chr> NA, NA, NA, NA, "at://did:plc:3mcek454ldmpf2xr43auvhac/a…
#> $ is_reskeet    <lgl> FALSE, FALSE, TRUE, TRUE, FALSE, TRUE, FALSE, TRUE, TRUE…
```

## Analyzing Feeds on Blue Sky

On Blue Sky users have the ability to create custom feeds based on
specific keywords. These feeds aggregate content, for instance, a user
might curate a feed around the hashtag `#rstats` to gather all relevant
content about. Let’s delve into the dynamics of such feeds.

Our starting point is to extract the posts from the `#rstats` feed
created by “andrew.heiss.phd”.

``` r
# Fetching the feed posts
feeds <- get_feeds_created_by(actor = "andrew.heiss.phd") 

# Filtering for a specific keyword, for example "#rstats"
rstat_feed <- feeds |>
  filter(displayName == "#rstats")

# Extracting posts from this curated feed
rstat_posts <- get_feed(rstat_feed$uri, limit = 200) |>
  dplyr::glimpse()
#> Rows: 95
#> Columns: 15
#> $ uri           <chr> "at://did:plc:kizxn77jkp4p5vqzapbedvg2/app.bsky.feed.pos…
#> $ cid           <chr> "bafyreiaks6igx35o4ygibk372rfjz3t5c7m5an4hmm5mlrnvgh7zo5…
#> $ author_handle <chr> "pmaier1971.bsky.social", "pmaier1971.bsky.social", "urb…
#> $ author_name   <chr> "Philipp Maier", "Philipp Maier", "Rafael H. M. Pereira …
#> $ text          <chr> "Weekly Initial Claims (first-time applications for unem…
#> $ author_data   <list> ["did:plc:kizxn77jkp4p5vqzapbedvg2", "pmaier1971.bsky.s…
#> $ post_data     <list> ["Weekly Initial Claims (first-time applications for un…
#> $ embed_data    <list> ["app.bsky.embed.images#view", [["https://cdn.bsky.app/…
#> $ reply_count   <int> 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 4, 1, 1, 0, 2, 0, 0, 0,…
#> $ repost_count  <int> 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 3, 0, 4, 0,…
#> $ like_count    <int> 0, 0, 1, 0, 1, 1, 4, 2, 0, 0, 1, 19, 3, 0, 0, 10, 1, 12,…
#> $ indexed_at    <dttm> 2024-01-04 14:09:02, 2024-01-04 14:08:43, 2024-01-04 13…
#> $ in_reply_to   <chr> NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, …
#> $ in_reply_root <chr> NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, …
#> $ quotes        <chr> NA, NA, NA, NA, NA, "at://did:plc:w4dzg6tdavlznotnfa2vth…
```

## Learn More?

Start with the [Basic
Usage](https://jbgruber.github.io/atrrr/articles/Basic_Usage.html)
vignette to learn more.

# Want to help?

You can help by creating an
[issue](https://github.com/JBGruber/atrrr/issues/new/choose) requesting
new features or reporting bugs.

If you are a developer, we are happy to accept pull requests. It should
be fairly straightforward, as all endpoints are already covered by
automatically generated function. For example, the endpoint
[app.bsky.actor.getProfiles](https://atproto.com/lexicons/app-bsky) is
accessible via `atrrr:::app_bsky_actor_get_profiles()`. The function
`get_user_info()` is just a thin wrapper around that and calls an
optional parsing function:

    get_user_info <- function(actor,
                              parse = TRUE,
                              .token = NULL) {

      # we need to use do.call so objects are passed to the right environment
      res <- do.call( 
        what = app_bsky_actor_get_profiles,
        args = list(
          actor,
          .token = .token, # tokens are handled automatically under the hood
          .return = "json"
        )) |>
        purrr::pluck("profiles")

      if (parse) {
        res <- parse_actors(res)
      }
      return(res)
    }

If you find an endpoint at <https://atproto.com/lexicons/com-atproto> or
<https://atproto.com/lexicons/app-bsky> that interests you, you can
write a similar wrapper and contribute it to the package (or build
something new on top of it). But please open an
[issue](https://github.com/JBGruber/atrrr/issues) first, so we don’t do
duplicated work.

[^1]: before 2024-01-04, this package was [called
    `atr`](https://github.com/JBGruber/atrrr/issues/12).
