% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlon_to_grid.R
\name{grid_to_latlon}
\alias{grid_to_latlon}
\title{grid_to_latlon converts the ATPOL grid to latitude and longitude.
With \code{xoffset = 0} and \code{yoffset = 0} parameters it returns coordinates of the upper left corner of the grid.}
\usage{
grid_to_latlon(grid, xoffset = 0.5, yoffset = 0.5)
}
\arguments{
\item{grid}{An ATPOL grid, ex. "GF2345".}

\item{xoffset}{An offset in X, where 0 is for left, and 1 for right side of the grid. The default value is 0.5, which corresponds to middle of the grid.}

\item{yoffset}{An offset in Y, where 0 is for top, and 1 for bottom side of the grid. The default value is 0.5, which corresponds to middle of the grid.}
}
\value{
latitude and longitude of ATPOL grid (default centroid) as pair of numerics
}
\description{
grid_to_latlon converts the ATPOL grid to latitude and longitude.
With \code{xoffset = 0} and \code{yoffset = 0} parameters it returns coordinates of the upper left corner of the grid.
}
\examples{
grid_to_latlon("BE21")
grid_to_latlon("BE21", 0, 0)
}
\references{
\url{https://atpol.sourceforge.io/}
}
