% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-ref-fishbase.R
\name{get_ref_fishbase}
\alias{get_ref_fishbase}
\title{Extract the bibliographic info from www.fishbase.org.}
\usage{
get_ref_fishbase(ref_id, mirror = "se")
}
\arguments{
\item{ref_id}{vector of reference ids.}

\item{mirror}{Character string defining the url mirror to use. Defaults to \code{se}.
In case data extraction is slow use a different mirror. Try to avoid frequently used mirrors
like \code{uk} or \code{com}.}
}
\value{
Dataframe
}
\description{
Extract bibliographic information for growth parameters (linf, k, t0) from www.fishbase.org
}
\examples{
\dontrun{
df <- get_growth_fishbase("Scyliorhinus canicula")

df$data_ref[df$data_ref == df$main_ref] <- NA
df <- tidyr::gather_(data = df,
                     key_col = "ref_type",
                     value_col = "ref_id",
                     gather_cols = c("main_ref", "data_ref"), na.rm = TRUE)
ref_id <- unique(df$ref_id)
get_ref_fishbase(ref_id)
}
}
