% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-groups.R
\name{get_groups}
\alias{get_groups}
\alias{get_age_groups}
\alias{get_acronyms}
\alias{get_age_acronyms}
\alias{get_nonage_acronyms}
\alias{get_fish_acronyms}
\title{Collection of similar functions which get specific
columns from the Atlantis \code{functionalGroups.csv}}
\usage{
get_groups(fgs)

get_age_groups(fgs)

get_acronyms(fgs)

get_age_acronyms(fgs)

get_nonage_acronyms(fgs)

get_fish_acronyms(fgs)
}
\arguments{
\item{fgs}{Character string giving the connection to the functional groups file.
The filename usually contains \code{Groups} and does end in \code{.csv}.}
}
\value{
Character string.
}
\description{
This collection of functions uses the dataframe of functional
groups created with \code{\link{load_fgs}} and creates various
character strings of group names or acronym names.
}
\details{
Currently, the following character strings can be created
- get_groups: Extract column "Name"
- get_age_groups: Extract column "Name". Selects groups with 10 ageclasses.
- get_acronym: Extract column "Code"
- get_age_acronym: Extract column "Code". Selects groups with 10 ageclasses.
- get_nonage_acronym: Extracts columns "Code". Only groups with ageclasses different from 10 are selected.
- get_fish_acronyms: Extract column "Code". Only groups with InvertType equal to "FISH" or "SHARK" are selected.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
fgs <- file.path(d, "SETasGroupsDem_NoCep.csv")

get_age_groups(fgs)
get_nonage_acronyms(fgs)
}
\seealso{
Other get functions: \code{\link{get_boundary}},
  \code{\link{get_colpal}}, \code{\link{get_conv_mgnbiot}}
}
