% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-add-range.R
\name{plot_add_range}
\alias{plot_add_range}
\title{Low level plotting function to add range of observed values to time series plots.}
\usage{
plot_add_range(plot, ex_data)
}
\arguments{
\item{plot}{ggplot2 object.}

\item{ex_data}{Dataframe with observed values for the specific timeseries.}
}
\value{
ggplot2 plot.
}
\description{
This function can be used to add the range of observed data to a timeseries plot
generated with \code{\link{plot_line}}. The density of the color gives an indication
of the likelihood of the value.
}
\examples{
# There is no external data so we need to add some noise first!
ex_data <- preprocess$biomass
ex_data$atoutput <- ex_data$atoutput * runif(n = nrow(ex_data), 0, 1)
ex_data$model <- "test"

# Create the timeseries with \\code{\\link{plot_line}}
plot <- plot_line(preprocess$biomass)

# Add the external data as geom_rug with \\code{\\link{plot_add_range}}
plot_add_range(plot, ex_data)
}
\seealso{
Other low-level-plot functions: \code{\link{plot_add_box}}
}
