% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-other.R, R/is-other.R
\name{assert_all_are_divisible_by}
\alias{assert_all_are_divisible_by}
\alias{assert_all_are_even}
\alias{assert_all_are_odd}
\alias{assert_any_are_divisible_by}
\alias{assert_any_are_even}
\alias{assert_any_are_odd}
\alias{is_divisible_by}
\alias{is_even}
\alias{is_odd}
\title{Is the input divisible by a number?}
\usage{
assert_all_are_divisible_by(x, n, tol = 100 * .Machine$double.eps)

assert_any_are_divisible_by(x, n, tol = 100 * .Machine$double.eps)

assert_all_are_even(x, tol = 100 * .Machine$double.eps)

assert_any_are_even(x, tol = 100 * .Machine$double.eps)

assert_all_are_odd(x, n, tol = 100 * .Machine$double.eps)

assert_any_are_odd(x, n, tol = 100 * .Machine$double.eps)

assert_all_are_odd(x, n, tol = 100 * .Machine$double.eps)

assert_any_are_odd(x, n, tol = 100 * .Machine$double.eps)

is_divisible_by(x, n, tol = 100 * .Machine$double.eps)

is_even(x, tol = 100 * .Machine$double.eps)

is_odd(x, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{x}{A numeric vector to divide.}

\item{n}{A numeric vector to divide by.}

\item{tol}{Differences from zero smaller than \code{tol} are not considered.}
}
\value{
\code{TRUE} if the input \code{x} is divisible by \code{n}, within
the specified tolerance.
}
\description{
Checks to see if the input is divisible by some number.
}
\note{
\code{is_even} and \code{is_odd} are shortcuts for divisibility by two.
}
\examples{
is_divisible_by(1:10, 3)
is_divisible_by(-5:5, -2)
is_divisible_by(1.5:10.5, c(1.5, 3.5))
assert_any_are_even(1:10)
dont_stop(assert_all_are_even(1:10))
}
\seealso{
\code{is_whole_number}
}

