% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-matrix.R, R/is-matrix.R
\name{assert_is_lower_triangular_matrix}
\alias{assert_is_lower_triangular_matrix}
\alias{assert_is_upper_triangular_matrix}
\alias{is_lower_triangular_matrix}
\alias{is_upper_triangular_matrix}
\title{Is the matrix upper/lower triangular?}
\usage{
assert_is_lower_triangular_matrix(x, strictly = FALSE, tol = 100 *
  .Machine$double.eps, severity = getOption("assertive.severity",
  "stop"))

assert_is_upper_triangular_matrix(x, strictly = FALSE, tol = 100 *
  .Machine$double.eps, severity = getOption("assertive.severity",
  "stop"))

is_lower_triangular_matrix(x, strictly = FALSE, tol = 100 *
  .Machine$double.eps, .xname = get_name_in_parent(x))

is_upper_triangular_matrix(x, strictly = FALSE, tol = 100 *
  .Machine$double.eps, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{strictly}{Logical. If \code{TRUE}, the diagonal must consist of zeroes.}

\item{tol}{Abolute deviations from the expected values smaller than 
\code{tol} are not considered.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{TRUE} if the input is all zeroes (after coercion to be a 
matrix).
}
\description{
Checks that the input is an upper or lower triangular matrix.
}
\examples{
x <- matrix(c(1, 2, 3, 0, 5, 6, 0, 0, 9), nrow = 3)
is_lower_triangular_matrix(x)
is_lower_triangular_matrix(x, strictly = TRUE)
is_upper_triangular_matrix(t(x))
is_upper_triangular_matrix(t(x), strictly = TRUE)
x[1, 2] <- 100 * .Machine$double.eps
is_lower_triangular_matrix(x)
x[2, 3] <- 101 * .Machine$double.eps
is_lower_triangular_matrix(x)
}
