% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has.R
\name{assert_no_duplicates}
\alias{assert_no_duplicates}
\title{Assert that the input vector has no duplicates}
\usage{
assert_no_duplicates(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{A vector.}

\item{msg}{A character string containing the error message to display if \code{x} has duplicates.}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} has no duplicates, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert the input vector has no duplicated elements
}
\examples{
try({
assert_no_duplicates(c(1, 2, 3))  # Passes
assert_no_duplicates(c(1, 2, 2))  # Throws default error

assert_no_duplicates(c(1, 2, 3), msg = "Custom error message")  # Passes
assert_no_duplicates(c(1, 2, 2), msg = "Custom error message")  # Throws custom error
})

}
\concept{assert_has}
