#######################################################################
# arules - Mining Association Rules and Frequent Itemsets
# Copyright (C) 2011-2015 Michael Hahsler, Christian Buchta,
# 			Bettina Gruen and Kurt Hornik
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


#' The Groceries Transactions Data Set
#'
#' The `Groceries` data set contains 1 month (30 days) of real-world
#' point-of-sale transaction data from a typical local grocery outlet.  The
#' data set contains 9835 transactions and the items are aggregated to 169
#' categories.
#'
#' If you use this data set in your paper, please cite to the paper in the
#' References Section.
#'
#' @name Groceries
#' @aliases groceries
#'
#' @docType data
#' @format Object of class [transactions].
#' @author Michael Hahsler
#' @references Michael Hahsler, Kurt Hornik, and Thomas Reutterer (2006)
#' Implications of probabilistic data modeling for mining association rules. In
#' M. Spiliopoulou, R. Kruse, C. Borgelt, A. Nuernberger, and W. Gaul, editors,
#' _From Data and Information Analysis to Knowledge Engineering, Studies
#' in Classification, Data Analysis, and Knowledge Organization_, pages
#' 598--605. Springer-Verlag.
#' @source The data set is provided for arules by Michael Hahsler, Kurt Hornik
#' and Thomas Reutterer.
#' @keywords datasets
NULL
