% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.freqlist.R
\name{summary.freqlist}
\alias{summary.freqlist}
\alias{as.data.frame.summary.freqlist}
\title{summary.freqlist}
\usage{
\method{summary}{freqlist}(object, ..., labelTranslations = NULL,
  title = NULL)

\method{as.data.frame}{summary.freqlist}(x, ..., list.ok = FALSE)
}
\arguments{
\item{object}{an object of class \code{\link{freqlist}}}

\item{...}{For \code{summary.freqlist}, these are passed to \code{\link{as.data.frame.freqlist}} (and hence to
\code{\link{freq.control}}). For the print method, these are
additional arguments passed to the \code{\link[knitr]{kable}} function.}

\item{labelTranslations}{A named list (or vector) where the name is the label in the
output to be replaced in the pretty rendering by the character string
value for the named element of the list, e.g., \code{list(age = "Age(Years)", meansd = "Mean(SD)")}.}

\item{title}{Title for the table, defaulting to \code{NULL} (no title)}

\item{x}{An object of class \code{summary.freqlist}.}

\item{list.ok}{If the object has multiple by-variables, is it okay to return a list of data.frames instead of a single data.frame?
If \code{FALSE} but there are multiple by-variables, a warning is issued.}
}
\value{
An object of class \code{"summary.freqlist"} (invisibly for the print method).
}
\description{
Summarize the \code{freqlist} object.
}
\examples{
# load mockstudy data
data(mockstudy)
tab.ex <- table(mockstudy[c("arm", "sex", "mdquality.s")], useNA = "ifany")
noby <- freqlist(tab.ex, na.options = "include")
summary(noby)
withby <- freqlist(tab.ex, strata = c("arm","sex"), na.options = "showexclude")
summary(withby)
summary(withby, dupLabels = TRUE)
}
\seealso{
\code{\link{freqlist}}, \code{\link[base]{table}}, \code{\link[stats]{xtabs}}, \code{\link[knitr]{kable}}
}
\author{
Tina Gunderson, with major revisions by Ethan Heinzen
}
