% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.data.frame.R
\name{compare.data.frame}
\alias{compare.data.frame}
\alias{print.compare.data.frame}
\title{Compare two data.frames and report differences}
\usage{
\method{compare}{data.frame}(x, y, by = NULL, by.x = by, by.y = by,
  control = NULL, ...)

\method{print}{compare.data.frame}(x, ...)
}
\arguments{
\item{x, y}{A data.frame to compare}

\item{by, by.x, by.y}{Which variables are IDs to merge the two data.frames?
If set to \code{"row.names"}, merging will occur over the row.names.
If set to \code{NULL} (default), merging will occur row-by-row.}

\item{control}{A list of control parameters from \code{\link{comparison.control}}.}

\item{...}{Other arguments, passed to \code{\link{comparison.control}} when appropriate.}
}
\description{
Compare two data.frames and report any differences between them,
 much like SAS's \code{PROC COMPARE} procedure.
}
\examples{

df1 <- data.frame(id = paste0("person", 1:3), a = c("a", "b", "c"),
                  b = c(1, 3, 4), c = c("f", "e", "d"),
                  row.names = paste0("rn", 1:3), stringsAsFactors = FALSE)
df2 <- data.frame(id = paste0("person", 3:1), a = c("c", "b", "a"),
                  b = c(1, 3, 4), d = paste0("rn", 1:3),
                  row.names = paste0("rn", c(1,3,2)), stringsAsFactors = FALSE)
summary(compare(df1, df2))
summary(compare(df1, df2, by = "id"))
summary(compare(df1, df2, by = "row.names"))
}
\seealso{
\code{\link{summary.compare.data.frame}}, \code{\link{n.diffs}}, \code{\link{n.diff.obs}}
}
\author{
Ethan Heinzen, adapted from code from Andrew Hanson
}
