% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.modelsum.R
\name{summary.modelsum}
\alias{summary.modelsum}
\alias{as.data.frame.summary.modelsum}
\alias{print.summary.modelsum}
\title{Summarize a \code{modelsum} object.}
\usage{
\method{summary}{modelsum}(object, ..., labelTranslations = NULL,
  text = FALSE, title = NULL, term.name = "")

\method{as.data.frame}{summary.modelsum}(x, ..., text = x$text,
  term.name = x$term.name, width = NULL, min.split = NULL)

\method{print}{summary.modelsum}(x, ..., format = if (!is.null(x$text) &&
  x$text \%in\% c("html", "latex")) x$text else "markdown",
  escape = x$text \%nin\% c("html", "latex"), width = NULL,
  min.split = NULL)
}
\arguments{
\item{object}{A \code{\link{modelsum}} object.}

\item{...}{For \code{summary.modelsum}, other arguments passed to \code{\link{as.data.frame.modelsum}}.
For \code{as.data.frame.summary.modelsum}, "width" and "min.split" are passed to \code{\link{smart.split}}.
For \code{print}ing the summary object, these are passed to both \code{as.data.frame.summary.modelsum} and
\code{\link[knitr]{kable}}.}

\item{labelTranslations}{A named list (or vector) where the name is the label in the
output to be replaced in the pretty rendering of modelsum by the character
string value for the named element of the list, e.g.,
\code{list(age = "Age(years)")}.}

\item{text}{An argument denoting how to print the summary to the screen.
Default is \code{FALSE} (show markdown output). \code{TRUE} and \code{NULL} output a text-only version, with
the latter avoiding all formatting.
\code{"html"} uses the HTML tag \code{<strong>} instead of the markdown formatting, and \code{"latex"} uses
the LaTeX command \code{\\textbf}.}

\item{title}{Title for the table, defaulting to \code{NULL} (no title)}

\item{term.name}{A character string denoting the column name for the first column.}

\item{x}{An object of class \code{"summary.modelsum"}.}

\item{width}{Passed to \code{\link{smart.split}} for formatting of the "term" column.}

\item{min.split}{Passed to \code{\link{smart.split}} for formatting of the "term" column.}

\item{format}{Passed to \code{\link[knitr]{kable}}: the format for the table. The default here is "markdown".
To use the default in \code{kable}, pass \code{NULL}. If \code{x$text} specifies LaTeX or HTML formatting,
that format is used in the table.}

\item{escape}{Passed to \code{\link[knitr]{kable}}: should special characters be escaped when printed?}
}
\value{
An object of class \code{"summary.modelsum"}
}
\description{
Format the information in \code{object} as a table using Pandoc coding or plain text, and cat it to stdout.
}
\seealso{
\code{\link{modelsum}}, \code{\link{print.modelsum}}, \code{\link{as.data.frame.modelsum}}
}
\author{
Ethan Heinzen, based on code originally by Greg Dougherty
}
