% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.freqlist.R
\name{summary.freqlist}
\alias{summary.freqlist}
\alias{print.summary.freqlist}
\title{summary.freqlist}
\usage{
\method{summary}{freqlist}(object, single = FALSE,
  labelTranslations = NULL, dupLabels = FALSE, title = NULL, ...,
  format = "markdown")

\method{print}{summary.freqlist}(x, ..., format = "markdown")
}
\arguments{
\item{object}{an object of class \code{\link{freqlist}}}

\item{single}{a logical value indicating whether to collapse results created using a groupBy variable into a single table for printing}

\item{labelTranslations}{A named list (or vector) where the name is the label in the output to
be replaced in the pretty rendering of freqlist by the character string value for the named
element of the list, e.g., list(age="Age(years)", bmi="Body Mass Index").}

\item{dupLabels}{Should labels which are the same as the row above be printed? The default (\code{FALSE}) more
closely approximates \code{PROC FREQ} output from SAS, where a label carried down from the row above is left blank.}

\item{title}{Title for the table, defaults to \code{NULL} (no title)}

\item{...}{For \code{summary.freqlist}, these are not used. For the print method, these are
additional arguments passed to the \code{\link[knitr]{kable}} function.}

\item{format}{Passed to \code{\link[knitr]{kable}}: the format for the table. The default here is "markdown".
To use the default in \code{kable}, pass \code{NULL}.}

\item{x}{An object of class \code{summary.freqlist}.}
}
\value{
An object of class \code{"summary.freqlist"} (invisibly for the print method).
}
\description{
Summarize the \code{freqlist} object.
}
\examples{
# load mockstudy data
data(mockstudy)
tab.ex <- table(mockstudy[, c("arm", "sex", "mdquality.s")], useNA = "ifany")
noby <- freqlist(tab.ex, na.options = "include")
summary(noby)
withby <- freqlist(tab.ex, groupBy = c("arm","sex"), na.options = "showexclude")
summary(withby)
summary(withby, dupLabels = TRUE)
}
\seealso{
\code{\link{freqlist}}, \code{\link[base]{table}}, \code{\link[stats]{xtabs}}, \code{\link[knitr]{kable}}
}
\author{
Tina Gunderson, with major revisions by Ethan Heinzen
}
